--TEST--
bcmod() function with large numbers
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$dividends = [
    "15151324141414.412312232141241",
    "-132132245132134.1515123765412",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
];
$divisors = array_merge($dividends, [
    "15",
    "-15",
    "1",
    "-9",
    "14.14",
    "-16.60",
    "0.15",
    "-0.01",
]);

run_bcmath_tests($dividends, $divisors, "mod", bcmod(...));

?>
--EXPECT--
Number "15151324141414.412312232141241" (scale 0)
15151324141414.412312232141241 mod 15151324141414.412312232141241 = 0
15151324141414.412312232141241 mod -132132245132134.1515123765412 = 15151324141414
15151324141414.412312232141241 mod 141241241241241248267654747412 = 15151324141414
15151324141414.412312232141241 mod -149143276547656984948124912   = 15151324141414
15151324141414.412312232141241 mod 0.1322135476547459213732911312 = 0
15151324141414.412312232141241 mod -0.123912932193769965476541321 = 0
15151324141414.412312232141241 mod 15                             = 4
15151324141414.412312232141241 mod -15                            = 4
15151324141414.412312232141241 mod 1                              = 0
15151324141414.412312232141241 mod -9                             = 1
15151324141414.412312232141241 mod 14.14                          = 5
15151324141414.412312232141241 mod -16.60                         = 12
15151324141414.412312232141241 mod 0.15                           = 0
15151324141414.412312232141241 mod -0.01                          = 0

Number "-132132245132134.1515123765412" (scale 0)
-132132245132134.1515123765412 mod 15151324141414.412312232141241 = -10921652000818
-132132245132134.1515123765412 mod -132132245132134.1515123765412 = 0
-132132245132134.1515123765412 mod 141241241241241248267654747412 = -132132245132134
-132132245132134.1515123765412 mod -149143276547656984948124912   = -132132245132134
-132132245132134.1515123765412 mod 0.1322135476547459213732911312 = 0
-132132245132134.1515123765412 mod -0.123912932193769965476541321 = 0
-132132245132134.1515123765412 mod 15                             = -4
-132132245132134.1515123765412 mod -15                            = -4
-132132245132134.1515123765412 mod 1                              = 0
-132132245132134.1515123765412 mod -9                             = -1
-132132245132134.1515123765412 mod 14.14                          = -13
-132132245132134.1515123765412 mod -16.60                         = -10
-132132245132134.1515123765412 mod 0.15                           = 0
-132132245132134.1515123765412 mod -0.01                          = 0

Number "141241241241241248267654747412" (scale 0)
141241241241241248267654747412 mod 15151324141414.412312232141241 = 8686992633814
141241241241241248267654747412 mod -132132245132134.1515123765412 = 123972365443639
141241241241241248267654747412 mod 141241241241241248267654747412 = 0
141241241241241248267654747412 mod -149143276547656984948124912   = 2558350610083521780455748
141241241241241248267654747412 mod 0.1322135476547459213732911312 = 0
141241241241241248267654747412 mod -0.123912932193769965476541321 = 0
141241241241241248267654747412 mod 15                             = 7
141241241241241248267654747412 mod -15                            = 7
141241241241241248267654747412 mod 1                              = 0
141241241241241248267654747412 mod -9                             = 4
141241241241241248267654747412 mod 14.14                          = 3
141241241241241248267654747412 mod -16.60                         = 16
141241241241241248267654747412 mod 0.15                           = 0
141241241241241248267654747412 mod -0.01                          = 0

Number "-149143276547656984948124912" (scale 0)
-149143276547656984948124912 mod 15151324141414.412312232141241 = -6434701710093
-149143276547656984948124912 mod -132132245132134.1515123765412 = -44045918171152
-149143276547656984948124912 mod 141241241241241248267654747412 = -149143276547656984948124912
-149143276547656984948124912 mod -149143276547656984948124912   = 0
-149143276547656984948124912 mod 0.1322135476547459213732911312 = 0
-149143276547656984948124912 mod -0.123912932193769965476541321 = 0
-149143276547656984948124912 mod 15                             = -2
-149143276547656984948124912 mod -15                            = -2
-149143276547656984948124912 mod 1                              = 0
-149143276547656984948124912 mod -9                             = -5
-149143276547656984948124912 mod 14.14                          = -7
-149143276547656984948124912 mod -16.60                         = -13
-149143276547656984948124912 mod 0.15                           = 0
-149143276547656984948124912 mod -0.01                          = 0

Number "0.1322135476547459213732911312" (scale 0)
0.1322135476547459213732911312 mod 15151324141414.412312232141241 = 0
0.1322135476547459213732911312 mod -132132245132134.1515123765412 = 0
0.1322135476547459213732911312 mod 141241241241241248267654747412 = 0
0.1322135476547459213732911312 mod -149143276547656984948124912   = 0
0.1322135476547459213732911312 mod 0.1322135476547459213732911312 = 0
0.1322135476547459213732911312 mod -0.123912932193769965476541321 = 0
0.1322135476547459213732911312 mod 15                             = 0
0.1322135476547459213732911312 mod -15                            = 0
0.1322135476547459213732911312 mod 1                              = 0
0.1322135476547459213732911312 mod -9                             = 0
0.1322135476547459213732911312 mod 14.14                          = 0
0.1322135476547459213732911312 mod -16.60                         = 0
0.1322135476547459213732911312 mod 0.15                           = 0
0.1322135476547459213732911312 mod -0.01                          = 0

Number "-0.123912932193769965476541321" (scale 0)
-0.123912932193769965476541321 mod 15151324141414.412312232141241 = 0
-0.123912932193769965476541321 mod -132132245132134.1515123765412 = 0
-0.123912932193769965476541321 mod 141241241241241248267654747412 = 0
-0.123912932193769965476541321 mod -149143276547656984948124912   = 0
-0.123912932193769965476541321 mod 0.1322135476547459213732911312 = 0
-0.123912932193769965476541321 mod -0.123912932193769965476541321 = 0
-0.123912932193769965476541321 mod 15                             = 0
-0.123912932193769965476541321 mod -15                            = 0
-0.123912932193769965476541321 mod 1                              = 0
-0.123912932193769965476541321 mod -9                             = 0
-0.123912932193769965476541321 mod 14.14                          = 0
-0.123912932193769965476541321 mod -16.60                         = 0
-0.123912932193769965476541321 mod 0.15                           = 0
-0.123912932193769965476541321 mod -0.01                          = 0

Number "15151324141414.412312232141241" (scale 10)
15151324141414.412312232141241 mod 15151324141414.412312232141241 = 0.0000000000
15151324141414.412312232141241 mod -132132245132134.1515123765412 = 15151324141414.4123122321
15151324141414.412312232141241 mod 141241241241241248267654747412 = 15151324141414.4123122321
15151324141414.412312232141241 mod -149143276547656984948124912   = 15151324141414.4123122321
15151324141414.412312232141241 mod 0.1322135476547459213732911312 = 0.0655398311
15151324141414.412312232141241 mod -0.123912932193769965476541321 = 0.0095762801
15151324141414.412312232141241 mod 15                             = 4.4123122321
15151324141414.412312232141241 mod -15                            = 4.4123122321
15151324141414.412312232141241 mod 1                              = 0.4123122321
15151324141414.412312232141241 mod -9                             = 1.4123122321
15151324141414.412312232141241 mod 14.14                          = 5.4323122321
15151324141414.412312232141241 mod -16.60                         = 12.0123122321
15151324141414.412312232141241 mod 0.15                           = 0.0623122321
15151324141414.412312232141241 mod -0.01                          = 0.0023122321

Number "-132132245132134.1515123765412" (scale 10)
-132132245132134.1515123765412 mod 15151324141414.412312232141241 = -10921652000818.8530145194
-132132245132134.1515123765412 mod -132132245132134.1515123765412 = 0.0000000000
-132132245132134.1515123765412 mod 141241241241241248267654747412 = -132132245132134.1515123765
-132132245132134.1515123765412 mod -149143276547656984948124912   = -132132245132134.1515123765
-132132245132134.1515123765412 mod 0.1322135476547459213732911312 = -0.1182110375
-132132245132134.1515123765412 mod -0.123912932193769965476541321 = -0.1185620881
-132132245132134.1515123765412 mod 15                             = -4.1515123765
-132132245132134.1515123765412 mod -15                            = -4.1515123765
-132132245132134.1515123765412 mod 1                              = -0.1515123765
-132132245132134.1515123765412 mod -9                             = -1.1515123765
-132132245132134.1515123765412 mod 14.14                          = -13.0715123765
-132132245132134.1515123765412 mod -16.60                         = -10.1515123765
-132132245132134.1515123765412 mod 0.15                           = -0.1015123765
-132132245132134.1515123765412 mod -0.01                          = -0.0015123765

Number "141241241241241248267654747412" (scale 10)
141241241241241248267654747412 mod 15151324141414.412312232141241 = 8686992633814.2424625456
141241241241241248267654747412 mod -132132245132134.1515123765412 = 123972365443639.7631318878
141241241241241248267654747412 mod 141241241241241248267654747412 = 0.0000000000
141241241241241248267654747412 mod -149143276547656984948124912   = 2558350610083521780455748.0000000000
141241241241241248267654747412 mod 0.1322135476547459213732911312 = 0.0325300077
141241241241241248267654747412 mod -0.123912932193769965476541321 = 0.0711933134
141241241241241248267654747412 mod 15                             = 7.0000000000
141241241241241248267654747412 mod -15                            = 7.0000000000
141241241241241248267654747412 mod 1                              = 0.0000000000
141241241241241248267654747412 mod -9                             = 4.0000000000
141241241241241248267654747412 mod 14.14                          = 3.4600000000
141241241241241248267654747412 mod -16.60                         = 16.4000000000
141241241241241248267654747412 mod 0.15                           = 0.1000000000
141241241241241248267654747412 mod -0.01                          = 0.0000000000

Number "-149143276547656984948124912" (scale 10)
-149143276547656984948124912 mod 15151324141414.412312232141241 = -6434701710093.8435198341
-149143276547656984948124912 mod -132132245132134.1515123765412 = -44045918171152.5846031960
-149143276547656984948124912 mod 141241241241241248267654747412 = -149143276547656984948124912.0000000000
-149143276547656984948124912 mod -149143276547656984948124912   = 0.0000000000
-149143276547656984948124912 mod 0.1322135476547459213732911312 = -0.0321624457
-149143276547656984948124912 mod -0.123912932193769965476541321 = -0.0895308287
-149143276547656984948124912 mod 15                             = -2.0000000000
-149143276547656984948124912 mod -15                            = -2.0000000000
-149143276547656984948124912 mod 1                              = 0.0000000000
-149143276547656984948124912 mod -9                             = -5.0000000000
-149143276547656984948124912 mod 14.14                          = -7.0400000000
-149143276547656984948124912 mod -16.60                         = -13.8000000000
-149143276547656984948124912 mod 0.15                           = -0.0500000000
-149143276547656984948124912 mod -0.01                          = 0.0000000000

Number "0.1322135476547459213732911312" (scale 10)
0.1322135476547459213732911312 mod 15151324141414.412312232141241 = 0.1322135476
0.1322135476547459213732911312 mod -132132245132134.1515123765412 = 0.1322135476
0.1322135476547459213732911312 mod 141241241241241248267654747412 = 0.1322135476
0.1322135476547459213732911312 mod -149143276547656984948124912   = 0.1322135476
0.1322135476547459213732911312 mod 0.1322135476547459213732911312 = 0.0000000000
0.1322135476547459213732911312 mod -0.123912932193769965476541321 = 0.0083006154
0.1322135476547459213732911312 mod 15                             = 0.1322135476
0.1322135476547459213732911312 mod -15                            = 0.1322135476
0.1322135476547459213732911312 mod 1                              = 0.1322135476
0.1322135476547459213732911312 mod -9                             = 0.1322135476
0.1322135476547459213732911312 mod 14.14                          = 0.1322135476
0.1322135476547459213732911312 mod -16.60                         = 0.1322135476
0.1322135476547459213732911312 mod 0.15                           = 0.1322135476
0.1322135476547459213732911312 mod -0.01                          = 0.0022135476

Number "-0.123912932193769965476541321" (scale 10)
-0.123912932193769965476541321 mod 15151324141414.412312232141241 = -0.1239129321
-0.123912932193769965476541321 mod -132132245132134.1515123765412 = -0.1239129321
-0.123912932193769965476541321 mod 141241241241241248267654747412 = -0.1239129321
-0.123912932193769965476541321 mod -149143276547656984948124912   = -0.1239129321
-0.123912932193769965476541321 mod 0.1322135476547459213732911312 = -0.1239129321
-0.123912932193769965476541321 mod -0.123912932193769965476541321 = 0.0000000000
-0.123912932193769965476541321 mod 15                             = -0.1239129321
-0.123912932193769965476541321 mod -15                            = -0.1239129321
-0.123912932193769965476541321 mod 1                              = -0.1239129321
-0.123912932193769965476541321 mod -9                             = -0.1239129321
-0.123912932193769965476541321 mod 14.14                          = -0.1239129321
-0.123912932193769965476541321 mod -16.60                         = -0.1239129321
-0.123912932193769965476541321 mod 0.15                           = -0.1239129321
-0.123912932193769965476541321 mod -0.01                          = -0.0039129321
