# Uplift Request Process Guide

An uplift can be requested of a patch landed on main in order to expedite that change into an earlier release outside of the standard train model.

The developer provides some information as part of the request to help inform the decision as to whether or not to accept the uplift. These requests are regularly monitored by Release Management. The release manager will then assess the potential risk/reward and make a decision on whether or not to accept the requested uplift. If the uplift is accepted, the release manager approves the request and grafts the patch to the Beta branch. If the request does not meet the criteria, the release manager may look for some additional information or reject the request and provide a reason.

There are some exceptions to the uplift approval process, here it is acceptable to create and merge the backport without uplift approval:
- A PR for an initial experiment generated by a script and has no impact on functionality - [example PR](https://github.com/mozilla-mobile/firefox-android/pull/1265)
- A PR that fixes/improves a test and has no impact on functionality.

## Beta/Release Uplift Steps

For Beta and Release, the following steps outline the process:
1. A PR that targets Firefox-Android main has an associated Bugzilla bug. The PR is linked as an attachment to the Bugzilla bug.
2. The PR goes through the standard review process and merges into the main branch.
3. There are 4 entry points to an uplift request:
- The developer recognizes that the PR is a candidate to backport to a release branch during development. A developer should ask their engineering or product manager for uplift approval before requesting uplift for features or big bug fixes.
    - Use Bugzilla’s “needinfo” to request engineering or product manager in the Bugzilla bug, so we have a record of the approvals.
    - Some features and technical changes may need decisions and guidance from the leadership team that can affect what is released to our users in the Beta and/or Production channels.
    - Uplifting small bug fixes doesn’t require approval from an engineering or product manager.
- An engineering or product manager may identify that a PR is applicable for an uplift request and reach out to the developer.
- The autonag bot may identify that a bug was fixed in main but Beta or Release are marked as affected. The bot will add a comment to the bug and needinfo the developer.
- Release Management may identify if a PR is a good candidate to backport and reach out to the developer via a comment in the bug.
4. If there is agreement and manager approval that the patch is suitable for uplift, the developer uses Mergify to create a [backport PR](https://docs.mergify.com/actions/backport/) for the applicable release branch.
- Example: `@Mergifyio backport releases_v111`
- NOTE: If there are merge conflicts, the developer is expected to resolve them prior to requesting approval.
- NOTE: Backports generally do not require an additional code review. However, if the patch requires any significant rebasing and/or re-architecting then it’s up to the developer to request a code review from the relevant code owner prior to requesting approval.
5. After the backport PR is attached to the bug (this should happen automatically), the developer views the Details of the attachment.
6. The developer selects “?” from the dropdown menu beside beta or release approval request.
- NOTE: The developer should choose beta or release depending on which channel the targeted version is currently on.
- NOTE: There can be a window of time around RC week where approval-mozilla-beta is requested, but no further beta builds are planned. In this scenario, the release manager will take care of changing the pending beta approval request to a release request instead.
7. The developer provides details for the approval request and clicks Submit.
- [Video Example of adding a uplift request](https://video.chevrel.org/demos/upliftRequestForm.mp4) 📺
8. The approval flag is added to the attachment and the information from the form is added as a comment in the bug.
9. The release manager regularly checks Bugzilla for uplift requests.
10. The release manager reviews the uplift approval request on the bug. If approved, they will change the approval status flag from ‘?’ to ‘+’ and add a comment indicating the next build that will include that change.
The release manager may also reject the request. In that case, the release manager will change the approval status flag from ‘?’ to ‘-’ and provide a reason for the rejection. Please see the below section on uplift request rejection for additional information.
11. The release manager will then approve and merge the PR in Github and update the bug with a link to the commit and set the affected version to fixed.
- NOTE: The manual bug marking steps are temporary until automation is in place to do so.

## Beta/Release Differences

The uplift request process for Beta and Release are essentially the same, with some notable differences not outlined above:
- During Beta:
 - Uplift requests are only tracked in Bugzilla.
 - Beta uplift requests are approved/rejected daily during the Beta cycle.
 - PR’s landed during beta are available in the next Beta build. The release manager will add a comment at the time of approval indicating what build that will be.
- During Release:
 - Uplift requests are tracked in Bugzilla and also in a release checklist maintained by the release manager.
 - Release uplift request approvals depend on where we are in the cycle. If the request is not a driver for an RC respin or a dot release, the request will pend as a potential ride-along until an appropriate RC respin or dot release is identified.
 - Where relevant, the release manager will include a release note for the uplift to be included in the release notes published in the Google Play Store for that dot release.

## Uplift Request Approval Form

The uplift request approval form in Bugzilla is the same as for Desktop uplift requests, guidelines are available [here](https://wiki.mozilla.org/Release_Management/Uplift_rules#Guidelines_on_approval_comments_for_Beta_and_Release).

## Uplift Request Rejection

There are several scenarios when a release manager may reject an uplift request. Here are some common examples:
- The uplift request is too late in the cycle for a release. For example, if we are in release candidate week for the next release then the release manager is already preparing builds that will include the fix.
- The uplift request is for a large change that has not had enough time to bake in nightly or beta.
- The uplift request is flagged as risky without a clear plan to mitigate risk.

When a release manager rejects an uplift request they will always provide a comment explaining the rejection. The release manager is always open to discussion if the developer does not accept the rejection. The discussion can be done via comments in the bug, a slack thread, an email exchange, or in a meeting.

If further alignment is needed between the developer and the release manager, the final call is with the Product team. The Product team can provide perspective on risk vs. reward.

## Backouts

If a PR landed in main, main was branched to release, and later it was discovered the PR introduced a regression without a simple fix then we may decide to back out the PR from the release branch. This would follow the same process as an uplift request.
