/*
    Copyright (C) 2003 Nikolas Zimmermann <wildfox@kde.org>
    This file is part of the KDE project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    aint with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef T2P_GLYPHTRACER_H
#define T2P_GLYPHTRACER_H

// FreeType 2 includes
#include <ft2build.h>
#include FT_FREETYPE_H

namespace T2P
{
	class Glyph;
	class BezierPath;
	class GlyphAffinePair;

	class GlyphTracer
	{
	public:
		GlyphTracer();
		virtual ~GlyphTracer();

		// Needs to be implemented
		virtual void correctGlyph(GlyphAffinePair *glyphAffine) = 0;
		virtual BezierPath *allocBezierPath(int size) = 0;
		virtual void closePath(Glyph *glyph) = 0;

		// FreeType glyph tracing functions
		void setMoveto(int (funcPtr)(FT_Vector *, void *));
		void setLineto(int (funcPtr)(FT_Vector *, void *));
		void setConicBezier(int (funcPtr)(FT_Vector *, FT_Vector *, void *));
		void setCubicBezier(int (funcPtr)(FT_Vector *, FT_Vector *, FT_Vector *, void *));

		FT_Outline_Funcs *outlineFuncs();

	private:
		FT_Outline_Funcs *m_outlineMethods;

		int (*m_moveTo)(FT_Vector *, void *);
		int (*m_lineTo)(FT_Vector *, void *);
		int (*m_conicBezier)(FT_Vector *, FT_Vector *, void *);
		int (*m_cubicBezier)(FT_Vector *, FT_Vector *, FT_Vector *, void *);
	};
};

#endif

// vim:ts=4:noet
