//
// anchor.h
//
// Part of KVIEWSHELL - A framework for multipage text/gfx viewers
//
// (C) 2004 Stefan Kebekus
// Distributed under the GPL

// Add header files alphabetically

#ifndef ANCHOR_H
#define ANCHOR_H


#include "pageNumber.h"

/** This very simple class respresents a certain vertical position on
    a certain page in a document. This position is identified by a
    pageNumber, and by the distance from the top of the page. */

class anchor {
 public:
  // constructs an anchor that points to an invalid page
  anchor() {page = 0;}

  // Returns true if the page number is valid, false otherwise
  bool isValid() {return page.isValid();}

  // constructs an snchor that points to page pg, and position
  // _distance_from_top_in_inch. The class contains no code to make
  // sure in any way that the page number pg exists, and that page pg,
  // if it exists, is taller than distance_from_top_in_inch
  anchor(PageNumber pg, double _distance_from_top_in_inch): page(pg), distance_from_top_in_inch(_distance_from_top_in_inch) {}

  PageNumber page;
  double     distance_from_top_in_inch;
};


#endif
