/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "print.h"

#include "entry.h"
#include "input.h"
#include "misc.h"
#include "widgets.h"

G_MODULE_EXPORT
int print_it(GtkTreeIter * iter, char *cmd, char *file)
{
    GError *error=NULL;
    gchar *command=g_strdup_printf("%s \"%s\"",cmd, file);

    print_diagnostics(NULL,"$",cmd," ",file,"\n",NULL);
   if (!g_spawn_command_line_async (command,&error)){
	  gchar *msg = g_strcompress (error->message);
	  print_diagnostics("xfce/error",msg,":\n",command,"\n",NULL);
	  g_error_free (error);
	  g_free (msg);
   } 
   g_free(command);
   return 1;
}

G_MODULE_EXPORT
void on_print_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    gchar *t=g_find_program_in_path("xfprint4");
    en = get_selected_entry(&iter);
    if(!en || !IS_FILE(en->type))
    {
	print_diagnostics("xfce/error", strerror(EINVAL)," : ",_("Print"),"\n", NULL);
	return;
    }
    if (t) {
	    print_it(NULL,t,en->path);
	    g_free(t);
	    t=NULL;
    } else {
	    show_input(PRINT_INPUT);
    }

}

G_MODULE_EXPORT
void tb_print(GtkWidget *w)
{
    on_print_activate((GtkMenuItem *) w, NULL);
}


G_MODULE_EXPORT
void
on_printer_configuration_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GError *error=NULL;
    const gchar *command="xfprint-manager";
    print_diagnostics(NULL,"$",command,"\n",NULL);

   if (!g_spawn_command_line_async (command,&error)){
	  gchar *msg = g_strcompress (error->message);
	  print_diagnostics("xfce/error",msg,":\n",command,"\n",NULL);
	  g_error_free (error);
	  g_free (msg);
   } 
}

