#include <stdio.h>
#include <glib.h>
#include <Python.h>

#if PY_VERSION_HEX < 0x03000000
# define LONGSUFFIX "L"
#else
# define LONGSUFFIX ""
#endif

int main(void)
{
  printf("# This part is generated by generate-constants.c\n");
  printf("G_MINFLOAT = %f\n", G_MINFLOAT);
  printf("G_MAXFLOAT = %f\n", G_MAXFLOAT);
  printf("G_MINDOUBLE = %f\n", G_MINDOUBLE);
  printf("G_MAXDOUBLE = %f\n", G_MAXDOUBLE);
  printf("G_MINSHORT = %d\n", G_MINSHORT);
  printf("G_MAXSHORT = %d\n", G_MAXSHORT);
  printf("G_MAXUSHORT = %u\n", G_MAXUSHORT);
  printf("G_MININT = %d\n", G_MININT);
  printf("G_MAXINT = %d\n", G_MAXINT);
  printf("G_MAXUINT = %u\n", G_MAXUINT);
  printf("G_MINLONG = %ld%s\n", G_MINLONG, LONGSUFFIX);
  printf("G_MAXLONG = %ld%s\n", G_MAXLONG, LONGSUFFIX);
  printf("G_MAXULONG = %lu%s\n", G_MAXULONG, LONGSUFFIX);
  printf("G_MININT8 = %hhd\n", G_MININT8);
  printf("G_MAXINT8 = %hhd\n", G_MAXINT8);
  printf("G_MAXUINT8 = %hhu\n", G_MAXUINT8);
  printf("G_MININT16 = %" G_GINT16_FORMAT "\n", G_MININT16);
  printf("G_MAXINT16 = %" G_GINT16_FORMAT "\n", G_MAXINT16);
  printf("G_MAXUINT16 = %" G_GUINT16_FORMAT "\n", G_MAXUINT16);
  printf("G_MININT32 = %" G_GINT32_FORMAT "\n", G_MININT32);
  printf("G_MAXINT32 = %" G_GINT32_FORMAT "\n", G_MAXINT32);
  printf("G_MAXUINT32 = %" G_GUINT32_FORMAT "\n", G_MAXUINT32);
  printf("G_MININT64 = %" G_GINT64_FORMAT "%s\n", G_MININT64, LONGSUFFIX);
  printf("G_MAXINT64 = %" G_GINT64_FORMAT "%s\n", G_MAXINT64, LONGSUFFIX);
  printf("G_MAXUINT64 = %" G_GUINT64_FORMAT "%s\n", G_MAXUINT64, LONGSUFFIX);
  printf("G_MAXSIZE = %" G_GSIZE_FORMAT "%s\n", G_MAXSIZE, LONGSUFFIX);
  printf("G_MAXSSIZE = %" G_GSSIZE_FORMAT "%s\n", G_MAXSSIZE, LONGSUFFIX);
  printf("G_MINOFFSET = %" G_GOFFSET_FORMAT "%s\n", G_MINOFFSET, LONGSUFFIX);
  printf("G_MAXOFFSET = %" G_GOFFSET_FORMAT "%s\n", G_MAXOFFSET, LONGSUFFIX);
  return 0;
}
